/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.item;

import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Arrays;
import lotr.client.render.item.LOTRRenderBow;
import lotr.common.LOTRCreativeTabs;
import lotr.common.LOTRMod;
import lotr.common.enchant.LOTREnchantment;
import lotr.common.enchant.LOTREnchantmentHelper;
import lotr.common.entity.item.LOTREntityArrowAvari;
import lotr.common.entity.item.LOTREntityArrowDragon;
import lotr.common.entity.item.LOTREntityArrowExplosion;
import lotr.common.entity.item.LOTREntityArrowHunger;
import lotr.common.entity.item.LOTREntityArrowMorgul;
import lotr.common.entity.item.LOTREntityArrowPoisoned;
import lotr.common.entity.item.LOTREntityArrowSlow;
import lotr.common.entity.item.LOTREntityArrowWeak;
import lotr.common.item.LOTREntityArrowFall;
import lotr.common.item.LOTREntityArrowFire;
import lotr.common.item.LOTRMaterial;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.ArrowLooseEvent;
import net.minecraftforge.event.entity.player.ArrowNockEvent;

public class LOTRItemBow
extends ItemBow {
    private Item.ToolMaterial bowMaterial;
    public final double arrowDamageFactor;
    private int bowPullTime;
    public static final float MIN_BOW_DRAW_AMOUNT = 0.65f;
    @SideOnly(value=Side.CLIENT)
    private IIcon[] bowPullIcons;

    public LOTRItemBow(LOTRMaterial material) {
        this(material.toToolMaterial(), 1.0);
    }

    public LOTRItemBow(LOTRMaterial material, double d) {
        this(material.toToolMaterial(), d);
    }

    public LOTRItemBow(Item.ToolMaterial material) {
        this(material, 1.0);
    }

    public LOTRItemBow(Item.ToolMaterial material, double d) {
        this.bowMaterial = material;
        this.func_77656_e((int)((float)material.func_77997_a() * 1.5f));
        this.func_77637_a(LOTRCreativeTabs.tabCombat);
        this.arrowDamageFactor = d;
        this.bowPullTime = 20;
    }

    public LOTRItemBow setDrawTime(int i) {
        this.bowPullTime = i;
        return this;
    }

    public void func_77615_a(ItemStack itemstack, World world, EntityPlayer entityplayer, int i) {
        int useTick = this.func_77626_a(itemstack) - i;
        ArrowLooseEvent event = new ArrowLooseEvent(entityplayer, itemstack, useTick);
        MinecraftForge.EVENT_BUS.post((Event)event);
        if (event.isCanceled()) {
            return;
        }
        useTick = event.charge;
        ItemStack arrowItem = null;
        int arrowSlot = this.getInvArrowSlot(entityplayer);
        if (arrowSlot >= 0) {
            arrowItem = entityplayer.field_71071_by.field_70462_a[arrowSlot];
        }
        boolean shouldConsume = this.shouldConsumeArrow(itemstack, entityplayer);
        if (arrowItem == null && !shouldConsume) {
            arrowItem = new ItemStack(Items.field_151032_g);
        }
        if (arrowItem != null) {
            float charge = (float)useTick / (float)this.getMaxDrawTime();
            if (charge < 0.65f) {
                return;
            }
            charge = (charge * charge + charge * 2.0f) / 3.0f;
            charge = Math.min(charge, 1.0f);
            EntityArrow arrow = arrowItem.func_77973_b() == LOTRMod.arrowMorgul ? new LOTREntityArrowMorgul(world, (EntityLivingBase)entityplayer, charge * 2.0f * LOTRItemBow.getLaunchSpeedFactor(itemstack)) : (arrowItem.func_77973_b() == LOTRMod.arrowPoisoned ? new LOTREntityArrowPoisoned(world, (EntityLivingBase)entityplayer, charge * 2.0f * LOTRItemBow.getLaunchSpeedFactor(itemstack)) : (arrowItem.func_77973_b() == LOTRMod.arrowWeak ? new LOTREntityArrowWeak(world, (EntityLivingBase)entityplayer, charge * 2.0f * LOTRItemBow.getLaunchSpeedFactor(itemstack)) : (arrowItem.func_77973_b() == LOTRMod.arrowSlow ? new LOTREntityArrowSlow(world, (EntityLivingBase)entityplayer, charge * 2.0f * LOTRItemBow.getLaunchSpeedFactor(itemstack)) : (arrowItem.func_77973_b() == LOTRMod.arrowExplosion ? new LOTREntityArrowExplosion(world, (EntityLivingBase)entityplayer, charge * 2.0f * LOTRItemBow.getLaunchSpeedFactor(itemstack)) : (arrowItem.func_77973_b() == LOTRMod.arrowAvari ? new LOTREntityArrowAvari(world, (EntityLivingBase)entityplayer, charge * 2.0f * LOTRItemBow.getLaunchSpeedFactor(itemstack)) : (arrowItem.func_77973_b() == LOTRMod.arrowDragon ? new LOTREntityArrowDragon(world, (EntityLivingBase)entityplayer, charge * 2.0f * LOTRItemBow.getLaunchSpeedFactor(itemstack)) : (arrowItem.func_77973_b() == LOTRMod.arrowFall ? new LOTREntityArrowFall(world, (EntityLivingBase)entityplayer, charge * 2.0f * LOTRItemBow.getLaunchSpeedFactor(itemstack)) : (arrowItem.func_77973_b() == LOTRMod.arrowHunger ? new LOTREntityArrowHunger(world, (EntityLivingBase)entityplayer, charge * 2.0f * LOTRItemBow.getLaunchSpeedFactor(itemstack)) : (arrowItem.func_77973_b() == LOTRMod.arrowFire ? new LOTREntityArrowFire(world, (EntityLivingBase)entityplayer, charge * 2.0f * LOTRItemBow.getLaunchSpeedFactor(itemstack)) : new EntityArrow(world, (EntityLivingBase)entityplayer, charge * 2.0f * LOTRItemBow.getLaunchSpeedFactor(itemstack)))))))))));
            if (arrow.func_70242_d() < 1.0) {
                arrow.func_70239_b(1.0);
            }
            if (charge >= 1.0f) {
                arrow.func_70243_d(true);
            }
            LOTRItemBow.applyBowModifiers(arrow, itemstack);
            itemstack.func_77972_a(1, (EntityLivingBase)entityplayer);
            world.func_72956_a((Entity)entityplayer, "random.bow", 1.0f, 1.0f / (field_77697_d.nextFloat() * 0.4f + 1.2f) + charge * 0.5f);
            boolean isProvident = LOTREnchantmentHelper.hasEnchant(itemstack, LOTREnchantment.rangedProvident);
            if (isProvident && field_77697_d.nextFloat() < 0.45f) {
                arrow.field_70251_a = 2;
                if (!world.field_72995_K) {
                    world.func_72838_d((Entity)arrow);
                }
                return;
            }
            if (!shouldConsume) {
                arrow.field_70251_a = 2;
            } else if (arrowSlot >= 0) {
                boolean allowInfinity;
                boolean isInfinity = LOTREnchantmentHelper.hasEnchant(itemstack, LOTREnchantment.rangedInfinity);
                boolean bl = allowInfinity = arrowItem.func_77973_b() == Items.field_151032_g;
                if (isInfinity && allowInfinity) {
                    arrow.field_70251_a = 0;
                } else {
                    --arrowItem.field_77994_a;
                    if (arrowItem.field_77994_a <= 0) {
                        entityplayer.field_71071_by.field_70462_a[arrowSlot] = null;
                    }
                }
            }
            if (!world.field_72995_K) {
                world.func_72838_d((Entity)arrow);
            }
        }
    }

    public static float getLaunchSpeedFactor(ItemStack itemstack) {
        float f = 1.0f;
        if (itemstack != null) {
            if (itemstack.func_77973_b() instanceof LOTRItemBow) {
                f = (float)((double)f * ((LOTRItemBow)itemstack.func_77973_b()).arrowDamageFactor);
            }
            f *= LOTREnchantmentHelper.calcRangedDamageFactor(itemstack);
        }
        return f;
    }

    public static void applyBowModifiers(EntityArrow arrow, ItemStack itemstack) {
        int power = EnchantmentHelper.func_77506_a((int)Enchantment.field_77345_t.field_77352_x, (ItemStack)itemstack);
        if (power > 0) {
            arrow.func_70239_b(arrow.func_70242_d() + (double)power * 0.5 + 0.5);
        }
        int punch = EnchantmentHelper.func_77506_a((int)Enchantment.field_77344_u.field_77352_x, (ItemStack)itemstack);
        if ((punch += LOTREnchantmentHelper.calcRangedKnockback(itemstack)) > 0) {
            arrow.func_70240_a(punch);
        }
        if (EnchantmentHelper.func_77506_a((int)Enchantment.field_77343_v.field_77352_x, (ItemStack)itemstack) + LOTREnchantmentHelper.calcFireAspect(itemstack) > 0) {
            arrow.func_70015_d(100);
        }
        for (LOTREnchantment ench : LOTREnchantment.allEnchantments) {
            if (!ench.applyToProjectile() || !LOTREnchantmentHelper.hasEnchant(itemstack, ench)) continue;
            LOTREnchantmentHelper.setProjectileEnchantment((Entity)arrow, ench);
        }
    }

    public int getMaxDrawTime() {
        return this.bowPullTime;
    }

    public ItemStack func_77659_a(ItemStack itemstack, World world, EntityPlayer entityplayer) {
        ArrowNockEvent event = new ArrowNockEvent(entityplayer, itemstack);
        MinecraftForge.EVENT_BUS.post((Event)event);
        if (event.isCanceled()) {
            return event.result;
        }
        if (!this.shouldConsumeArrow(itemstack, entityplayer) || this.getInvArrowSlot(entityplayer) >= 0) {
            entityplayer.func_71008_a(itemstack, this.func_77626_a(itemstack));
        }
        return itemstack;
    }

    private boolean shouldConsumeArrow(ItemStack itemstack, EntityPlayer entityplayer) {
        return !entityplayer.field_71075_bZ.field_75098_d && EnchantmentHelper.func_77506_a((int)Enchantment.field_77342_w.field_77352_x, (ItemStack)itemstack) == 0;
    }

    private int getInvArrowSlot(EntityPlayer entityplayer) {
        for (int slot = 0; slot < entityplayer.field_71071_by.field_70462_a.length; ++slot) {
            ItemStack invItem = entityplayer.field_71071_by.field_70462_a[slot];
            if (invItem == null || invItem.func_77973_b() != Items.field_151032_g && invItem.func_77973_b() != LOTRMod.arrowPoisoned && invItem.func_77973_b() != LOTRMod.arrowFire && invItem.func_77973_b() != LOTRMod.arrowDragon && invItem.func_77973_b() != LOTRMod.arrowFall && invItem.func_77973_b() != LOTRMod.arrowWeak && invItem.func_77973_b() != LOTRMod.arrowSlow && invItem.func_77973_b() != LOTRMod.arrowExplosion && invItem.func_77973_b() != LOTRMod.arrowAvari && invItem.func_77973_b() != LOTRMod.arrowHunger && invItem.func_77973_b() != LOTRMod.arrowMorgul) continue;
            return slot;
        }
        return -1;
    }

    public int func_77619_b() {
        return 1 + this.bowMaterial.func_77995_e() / 5;
    }

    public boolean func_82789_a(ItemStack itemstack, ItemStack repairItem) {
        return repairItem.func_77973_b() == Items.field_151007_F ? true : super.func_82789_a(itemstack, repairItem);
    }

    public BowState getBowState(EntityLivingBase entity, ItemStack usingItem, int useRemaining) {
        if (entity instanceof EntityPlayer && usingItem != null && usingItem.func_77973_b() == this) {
            int ticksInUse = usingItem.func_77988_m() - useRemaining;
            double useAmount = (double)ticksInUse / (double)this.bowPullTime;
            if (useAmount >= 0.9) {
                return BowState.PULL_2;
            }
            if (useAmount > 0.65) {
                return BowState.PULL_1;
            }
            if (useAmount > 0.0) {
                return BowState.PULL_0;
            }
        }
        return BowState.HELD;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(ItemStack itemstack, int renderPass, EntityPlayer entityplayer, ItemStack usingItem, int useRemaining) {
        BowState bowState = this.getBowState((EntityLivingBase)entityplayer, usingItem, useRemaining);
        if (bowState == BowState.PULL_0) {
            return this.bowPullIcons[0];
        }
        if (bowState == BowState.PULL_1) {
            return this.bowPullIcons[1];
        }
        if (bowState == BowState.PULL_2) {
            return this.bowPullIcons[2];
        }
        return this.field_77791_bV;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister iconregister) {
        this.field_77791_bV = iconregister.func_94245_a(this.func_111208_A());
        this.bowPullIcons = new IIcon[3];
        IItemRenderer bowRenderer = MinecraftForgeClient.getItemRenderer((ItemStack)new ItemStack((Item)this), (IItemRenderer.ItemRenderType)IItemRenderer.ItemRenderType.EQUIPPED_FIRST_PERSON);
        if (bowRenderer instanceof LOTRRenderBow && ((LOTRRenderBow)bowRenderer).isLargeBow()) {
            Arrays.fill(this.bowPullIcons, this.field_77791_bV);
        } else {
            this.bowPullIcons[0] = iconregister.func_94245_a(this.func_111208_A() + "_" + BowState.PULL_0.iconName);
            this.bowPullIcons[1] = iconregister.func_94245_a(this.func_111208_A() + "_" + BowState.PULL_1.iconName);
            this.bowPullIcons[2] = iconregister.func_94245_a(this.func_111208_A() + "_" + BowState.PULL_2.iconName);
        }
    }

    public static enum BowState {
        HELD(""),
        PULL_0("pull_0"),
        PULL_1("pull_1"),
        PULL_2("pull_2");

        public final String iconName;

        private BowState(String s) {
            this.iconName = s;
        }
    }
}

